<?php
namespace WPT_Divi_Gravity_Modules\GravityFormModule;

/**
 * .
 */
class Fields
{
    protected $container;
    protected $module;

    /**
     * Constructor.
     */
    public function __construct($container)
    {
        $this->container = $container;
    }

    /**
     * Set the module instance.
     */
    public function set_module($module)
    {
        $this->module = $module;
    }

    /**
     * Get selector
     */
    public function get_selector($key)
    {
        $selectors = $this->get_selectors();

        return $selectors[$key]['selector'];
    }

    /**
     * List of selectors
     */
    public function get_selectors()
    {
        return [
            'title'                           => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper h3.gform_title, {$this->module->main_css_element} div.gform_wrapper .gform_heading h2.gform_title",
                'name'     => 'Title',
            ],
            'description'                     => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper span.gform_description",
                'name'     => 'Description',
            ],
            'field_container'                 => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield",
                'name'     => 'Field Container',
            ],
            'label'                           => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper label.gfield_label, {$this->module->main_css_element} div.gform_wrapper legend.gfield_label",
                'name'     => 'Label',
            ],
            'sub_label'                       => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper li.gfield div.ginput_complex label:not([class^=gfield_label]), {$this->module->main_css_element} div.gform_wrapper  div.ginput_complex label:not([class^=gfield_label])",
                'name'     => 'Sub Label',
            ],
            'field_description'               => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper li.gfield div.gfield_description:not([class*=\"gfield_consent_description\"]), {$this->module->main_css_element} div.gform_wrapper div.gfield_description:not([class*=\"gfield_consent_description\"])",
                'name'     => 'Field Description',
            ],
            'input_general'                   => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file]), {$this->module->main_css_element} .gform_wrapper .gform_fields .gfield textarea, {$this->module->main_css_element} .gform_wrapper .gfield_checkbox label, {$this->module->main_css_element} .gform_wrapper .gfield_radio  label, {$this->module->main_css_element} .gform_wrapper .gfield select, {$this->module->main_css_element} .gform_wrapper .gfield select",
                'name'     => 'Input General',
            ],
            'placeholder'                     => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file])::placeholder, {$this->module->main_css_element} .gform_wrapper .gform_fields .gfield textarea::placeholder, {$this->module->main_css_element} .gform_wrapper .gfield_checkbox label::placeholder, {$this->module->main_css_element} .gform_wrapper .gfield_radio label::placeholder, {$this->module->main_css_element} .gform_wrapper .gfield select::placeholder",
                'name'     => 'Input Placeholder',
            ],
            'checkbox_radio_text'             => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper div.ginput_container_checkbox .gfield_checkbox label, {$this->module->main_css_element} .gform_wrapper div.ginput_container_radio .gfield_radio label",
                'name'     => 'Button',
            ],
            'checkbox_radio_input'            => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper input[type=checkbox], {$this->module->main_css_element} .gform_wrapper input[type=radio]",
                'name'     => 'Checkbox Input',
            ],
            'checkbox_radio_option_container' => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper div.ginput_container_checkbox .gfield_checkbox li label, {$this->module->main_css_element} .gform_wrapper div.ginput_container_radio .gfield_radio li label, {$this->module->main_css_element} .gform_wrapper div.ginput_container_checkbox .gfield_checkbox div, {$this->module->main_css_element} .gform_wrapper div.ginput_container_radio .gfield_radio div",
                'name'     => 'Checkbox/Radio Option Container',
            ],
            'consent_checkbox_label'          => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gfield div.ginput_container_consent label",
                'name'     => 'Consent Checkbox Label',
            ],
            'consent_container'               => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gform_fields .gfield div.ginput_container_consent",
                'name'     => 'Consent Container',
            ],
            'consent_description'             => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield div.gfield_description.gfield_consent_description",
                'name'     => 'Consent Description',
            ],
            'validation_error_container'      => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper div.validation_error, {$this->module->main_css_element} div.gform_wrapper .gform_validation_errors",
                'name'     => 'Validation Error Container',
            ],
            'validation_error_heading'        => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper div.validation_error, {$this->module->main_css_element} div.gform_wrapper .gform_validation_errors h2",
                'name'     => 'Validation Error Heading',
            ],
            'field_validation_error'          => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield.gfield_error div.gfield_description.validation_message",
                'name'     => 'Field Validation Error',
            ],
            'error_field_container'           => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gfield.gfield_error, {$this->module->main_css_element} .gform_wrapper .gfield_validation_message, {$this->module->main_css_element}  .gform_wrapper .validation_message",
                'name'     => 'Error Field Container',
            ],
            'confirmation_message'            => [
                'selector' => "{$this->module->main_css_element} div.gform_confirmation_wrapper div.gform_confirmation_message",
                'name'     => 'Confirmation Message',
            ],
            'confirmation_wrapper'            => [
                'selector' => "{$this->module->main_css_element} div.gform_confirmation_wrapper",
                'name'     => 'Confirmation Wrapper',
            ],
            'progress_bar_title'              => [
                'selector' => "{$this->module->main_css_element} .gf_progressbar_title,  {$this->module->main_css_element} .gf_progressbar_wrapper .gf_progressbar_title ",
                'name'     => 'Progress Bar Title',
            ],
            'progress_bar_percentage'         => [
                'selector' => "{$this->module->main_css_element} div.gf_progressbar_wrapper div.gf_progressbar div.gf_progressbar_percentage",
                'name'     => 'Progress Bar Percentage',
            ],
            'section_field'                   => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield.gsection",
                'name'     => 'Section Field Wrapper',
            ],
            'section_field_title'             => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield.gsection .gsection_title",
                'name'     => 'Section Field Title',
            ],
            'section_field_description'       => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper .gfield.gsection .gsection_description",
                'name'     => 'Section Field Description',
            ],
            'text_field'                      => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file])",
                'name'     => 'Text Field',
            ],
            'number_field'                    => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper input[type=number]",
                'name'     => 'Text Field',
            ],
            'textarea_field'                  => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gfield textarea",
                'name'     => 'TextArea Field',
            ],
            'select_field'                    => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper select",
                'name'     => 'Select Field',
            ],
            'button'                          => [
                'selector' => "{$this->module->main_css_element} .et_pb_button",
                'name'     => 'Button',
            ],
            'button_hover'                    => [
                'selector' => "{$this->module->main_css_element} .et_pb_button:hover",
                'name'     => 'Button Hover',
            ],
            'footer'                          => [
                'selector' => "{$this->module->main_css_element} .gform_page_footer, %%order_class%% .gform_footer, {$this->module->main_css_element} div[data-field-class='gform_editor_submit_container']",
                'name'     => 'Footer',
            ],
            'list_column'                     => [
                'selector' => "{$this->module->main_css_element} .gfield .gfield_list thead th",
                'name'     => 'List Column',
            ],
            'gf_left_half'                    => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper li.gfield.gf_left_half",
                'name'     => 'CSS Ready Class - gf_left_half',
            ],
            'gf_left_third_gf_middle_third'   => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper li.gfield.gf_left_third, {$this->module->main_css_element} .gform_wrapper li.gfield.gf_middle_third",
                'name'     => 'CSS Ready Class - gf_left_third + gf_middle_third',
            ],
            'gf_date_dropdown_date_field'     => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_date_dropdown_day,{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_date_dropdown_month,{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_date_dropdown_year,{$this->module->main_css_element} div.gform_wrapper div.ginput_container.ginput_container_date",
                'name'     => 'Date Drop Down & Date Field',
            ],
            'ampm_dropdown_field'             => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_time_ampm",
                'name'     => 'AM/PM Drop Down Field',
            ],
            'time_fields'                     => [
                'selector' => "{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_time_minute,{$this->module->main_css_element} div.gform_wrapper div.ginput_container.gfield_time_hour",
                'name'     => 'HH/MM Field',
            ],
            'asterisk'                        => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gfield_required",
                'name'     => 'Asterisk',
            ],
            'asterisk_text_legend'            => [
                'selector' => "{$this->module->main_css_element} .gform_wrapper .gform_required_legend",
                'name'     => 'Asterisk Legend Text',
            ],
        ];
    }

    /**
     * Asterisk Legend Text
     */
    public function asterisk_legend_text_fields__premium_only()
    {
        $fields = [];

        return $fields;
    }

    public function asterisk__premium_only()
    {
        $fields = [];

        $fields['asterisk_color'] = [
            'label'       => esc_html__('Font Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'asterisk',
            'description' => esc_html__('Select the asterisk font color.', 'et_builder'),
            'show_if'     => [],
            'default'     => $this->get_default('asterisk_color'),
        ];

        return $fields;
    }

    public function time_fields__premium_only()
    {
        $fields = [];

        $fields['ampm_field_margin_left'] = [
            'label'          => esc_html__('AM/PM Drop Down Margin Left', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 400,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'time_field',
            'description'    => esc_html__('Set the margin left value for AM/PM dropdown', 'et_builder'),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('ampm_field_margin_left'),
        ];

        $fields['time_field_min_width'] = [
            'label'          => esc_html__('Time (HH/MM) Field Min Width', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 400,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'time_field',
            'description'    => esc_html__('Set the minimum width for HH/MM Fields', 'et_builder'),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('time_field_min_width'),
        ];

        return $fields;
    }

    /**
     * Date drop down and date fields
     */
    public function date_dropdown_date_field__premium_only()
    {
        $fields = [];

        $fields['date_field_margin_right'] = [
            'label'          => esc_html__('Margin Right', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 400,
                'step' => 1,
            ],
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'date_dropdown_date_field',
            'description'    => esc_html__('Set the margin right value for date field dropdown', 'et_builder'),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('date_field_margin_right'),
        ];

        return $fields;
    }

    public function checkbox_radio_field_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'checkbox_radio_field',
            'advanced',
            'checkbox_radio_field',
            '8px|0|8px|0',
            '0|0|0|0'
        );
        return $fields;
    }

    public function confirmation_message_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'confirmation_message',
            'advanced',
            'confirmation_message',
            '0|0|0|0',
            '30px|10px|30px|10px'
        );

        $fields['confirmation_message_background_color'] = [
            'label'       => esc_html__('Background Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'confirmation_message',
            'default'     => $this->get_default('confirmation_message_background_color'),
        ];

        return $fields;
    }

    public function consent_checkbox_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'consent_checkbox',
            'advanced',
            'consent_checkbox',
            '0|0|0|0',
            '8px|0|8px|0'
        );

        return $fields;
    }

    public function consent_description_fields()
    {

        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'consent_description',
            'advanced',
            'consent_description',
            '0|0|0|0',
            '20px|20px|20px|20px'
        );

        return $fields;
    }

    public function description_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'description',
            'advanced',
            'description',
            '0|0|16px|0',
            '0|0|0|0'
        );

        return $fields;
    }

    /**
     * Field container
     */
    public function field_container_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'field_container',
            'advanced',
            'field_container',
            '16px|0|0|0',
            '0|0|0|0'

        );

        return $fields;
    }

    public function field_description_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'field_description',
            'advanced',
            'field_description',
            '0|0|0|0',
            '16px|0|0|0'
        );

        return $fields;
    }

    public function field_validation_error_fields()
    {
        $fields = [];

        $fields['field_validation_border_color'] = [
            'label'       => esc_html__('Border Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'field_validation_error',
            'default'     => $this->get_default('field_validation_border_color'),
        ];

        $fields['field_validation_error_background_color'] = [
            'label'       => esc_html__('Background Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'field_validation_error',
            'default'     => $this->get_default('field_validation_error_background_color'),
        ];

        $margin_padding = $this->container['margin_padding']->get_margin_padding_field(
            'field_validation_error',
            'advanced',
            'field_validation_error',
            '0|0|0|0',
            '0|0|0|0'
        );

        $fields = array_merge($fields, $margin_padding);

        return $fields;

    }

    public function footer_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'footer',
            'advanced',
            'footer',
            '16px|0|0|0',
            '16px|0|10px|0'
        );
        return $fields;
    }

    /**
     * Get default for given keys
     */
    public function get_default($key)
    {
        $defaults = $this->get_defaults();

        return isset($defaults[$key]) ? $defaults[$key] : '';
    }

    /**
     * Get defaults
     */
    public function get_defaults()
    {
        $defaults = [
            'gravityform_id'                     => 'gf-0',
            'title'                              => 'on',
            'description'                        => 'on',
            'ajax'                               => 'off',
            'tabindex'                           => '0',
            'field_values'                       => '',
            'gf_left_half_padding_right'         => '16px',
            'gf_left_middle_third_padding_right' => '16px',
        ];

        $defaults['text_input_bg_color']                     = '#eeeeee';
        $defaults['border_radii_input_general']              = 'on||||';
        $defaults['field_validation_border_color']           = '#C89797';
        $defaults['field_validation_error_background_color'] = '';
        $defaults['confirmation_message_background_color']   = '#eeeeee';
        $defaults['progress_bar_color']                      = '#036493';
        $defaults['progress_bar_text_color']                 = '#ffffff';
        $defaults['section_field_border_color']              = '#cccccc';
        $defaults['border_style_all_input_general']          = 'solid';
        $defaults['date_field_margin_right']                 = '8px';
        $defaults['ampm_field_margin_left']                  = '8px';
        $defaults['time_field_min_width']                    = '64px';
        $defaults['asterisk_color']                          = '#C02B0A';
        $defaults['form_error_background']                   = '#FFF9F9';

        return $defaults;
    }

    /**
     * Get module fields
     */
    public function get_fields()
    {
        $fields = [];

        $fields['admin_label'] = [
            'label'       => __('Admin Label', 'et_builder'),
            'type'        => 'text',
            'description' => 'This will change the label of the module in the builder for easy identification.',
        ];

        return $fields
         + $this->get_gravityform_shortcode_param_fields()
         + $this->footer_fields()
         + $this->description_fields()
         + $this->field_container_fields()
         + $this->gf_left_half_fields()
         + $this->gf_left_middle_third_fields()
         + $this->input_container_fields()
         + $this->consent_description_fields()
         + $this->consent_checkbox_fields()
         + $this->input_general_fields()
         + $this->text_input_fields()
         + $this->select_field_fields()
         + $this->checkbox_radio_field_fields()
         + $this->label_fields()
         + $this->sub_label_fields()
         + $this->field_description_fields()
         + $this->validation_error_heading_fields()
         + $this->field_validation_error_fields()
         + $this->confirmation_message_fields()
         + $this->progress_bar_title_fields()
         + $this->progress_bar_fields()
         + $this->section_field_title()
         + $this->section_field_description()
         + $this->section_field()
         + $this->date_dropdown_date_field__premium_only()
         + $this->time_fields__premium_only()
         + $this->asterisk__premium_only()
         + $this->asterisk_legend_text_fields__premium_only()
         + $this->title_fields();
    }

    public function get_gravityform_shortcode_param_fields()
    {
        $fields = [];

        $fields['gravityform_id'] = [
            'label'       => esc_html__('Form ID', 'et_builder'),
            'type'        => 'select',
            'options'     => $this->container['gravityform']->get_active_form_options(),
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__('Select the gravity form', 'et_builder'),
            'default'     => $this->get_default('gravityform_id'),
        ];

        $fields['title'] = [
            'label'       => esc_html__('Show Title', 'et_builder'),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__('Off', 'et_builder'),
                'on'  => esc_html__('On', 'et_builder'),
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__('Select `Yes` to show title', 'et_builder'),
            'default'     => $this->get_default('title'),
        ];

        $fields['description'] = [
            'label'       => esc_html__('Show Description', 'et_builder'),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__('Off', 'et_builder'),
                'on'  => esc_html__('On', 'et_builder'),
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__('Select `Yes` to show description', 'et_builder'),
            'default'     => $this->get_default('description'),
        ];

        $fields['ajax'] = [
            'label'       => esc_html__('Enable Ajax', 'et_builder'),
            'type'        => 'yes_no_button',
            'options'     => [
                'off' => esc_html__('Off', 'et_builder'),
                'on'  => esc_html__('On', 'et_builder'),
            ],
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__('Select `Yes` to submit form via ajax', 'et_builder'),
            'default'     => $this->get_default('ajax'),
        ];

        $fields['tabindex'] = [
            'label'          => esc_html__('Tab Index', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
            'tab_slug'       => 'general',
            'toggle_slug'    => 'main_content',
            'description'    => esc_html__('Specify the starting tab index for the fields of this form.', 'et_builder'),
            'allowed_units'  => [''],
            'default_unit'   => '',
            'default'        => $this->get_default('tabindex'),
        ];

        $fields['field_values'] = [
            'label'       => esc_html__('Field Values', 'et_builder'),
            'type'        => 'text',
            'tab_slug'    => 'general',
            'toggle_slug' => 'main_content',
            'description' => esc_html__('Specify the default field values. Example: name=Warren&check=First Choice,Second Choice', 'et_builder'),
            'default'     => $this->get_default('field_values'),
        ];

        return $fields;
    }

    /**
     * Input container
     */
    public function input_container_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'input_container',
            'advanced',
            'input_container',
            '8px|0|0|0',
            '0|0|0|0'

        );

        return $fields;
    }

    public function input_general_fields()
    {
        $fields = [];

        $fields['text_input_bg_color'] = [
            'label'       => esc_html__('Background Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'input_font',
            'default'     => $this->get_default('text_input_bg_color'),
        ];

        $borderFactory = \ET_Builder_Module_Fields_Factory::get('Border');
        $borderFields  = $borderFactory->get_fields([
            'suffix'      => '_input_general',
            'toggle_slug' => 'input_font',
            'defaults'    => [
                'border_radii'  => 'on||||',
                'border_styles' => [
                    'width' => '1px',
                    'color' => '#bbbbbb',
                    'style' => 'solid',
                ],
            ],

        ]);

        $fields = array_merge($fields, $borderFields);

        return $fields;
    }

    public function label_fields()
    {

        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'label',
            'advanced',
            'label',
            '0|0|0|0',
            '0|0|0|0'
        );

        return $fields;
    }

    public function progress_bar_fields()
    {
        $fields = [];

        $fields['progress_bar_color'] = [
            'label'       => esc_html__('Progress Bar Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'progress_bar',
            'default'     => $this->get_default('progress_bar_color'),
        ];

        $fields['progress_bar_text_color'] = [
            'label'       => esc_html__('Text Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'progress_bar',
            'default'     => $this->get_default('progress_bar_text_color'),
        ];

        return $fields;
    }

    public function progress_bar_title_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'progress_bar_title',
            'advanced',
            'progress_bar_title',
            '0|0|8px|12px',
            '0|0|0|0'

        );

        return $fields;
    }

    public function section_field()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'section_field',
            'advanced',
            'section_field',
            '0|0|0|0',
            '0|0|0|0'
        );

        $fields['section_field_border_color'] = [
            'label'       => esc_html__('Border Bottom Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'section_field',
            'description' => esc_html__('', 'et_builder'),
            'show_if'     => [],
            'default'     => $this->get_default('section_field_border_color'),
        ];
        return $fields;
    }

    public function section_field_description()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'section_field_description',
            'advanced',
            'section_field_description',
            '0|0|0|0',
            '0|0|0|0'
        );
        return $fields;
    }

    public function section_field_title()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'section_field_title',
            'advanced',
            'section_field_title',
            '0|0|0|0',
            '0|0|0|0'
        );
        return $fields;
    }

    public function select_field_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'select_field',
            'advanced',
            'select_field',
            '0|0|0|0',
            '16px|16px|16px|10px'

        );

        return $fields;
    }

    public function sub_label_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'sub_label',
            'advanced',
            'sub_label',
            '1px|0|9px|1px',
            '0|0|0|0'
        );

        return $fields;
    }

    public function text_input_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'text_input',
            'advanced',
            'text_input',
            '0|0|0|0',
            '16px|16px|16px|16px'

        );

        return $fields;
    }

    /**
     * Title fields
     */
    public function title_fields()
    {
        $fields = $this->container['margin_padding']->get_margin_padding_field(
            'title',
            'advanced',
            'title',
            '10px|0|6px|0',
            '0|0|0|0'

        );

        return $fields;
    }

    public function validation_error_heading_fields()
    {

        $fields['form_error_background'] = [
            'label'       => esc_html__('Background Color', 'et_builder'),
            'type'        => 'color-alpha',
            'tab_slug'    => 'advanced',
            'toggle_slug' => 'validation_error_heading',
            'description' => esc_html__('', 'et_builder'),
            'show_if'     => [],
            'default'     => $this->get_default('form_error_background'),
        ];

        $fields += $this->container['margin_padding']->get_margin_padding_field(
            'validation_error_heading',
            'advanced',
            'validation_error_heading',
            '0|0|25px|0',
            '16px|0|16px|0'
        );

        return $fields;
    }

    public function gf_left_half_fields()
    {
        $fields                               = [];
        $fields['gf_left_half_padding_right'] = [
            'label'          => esc_html__('Padding Right', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
            'mobile_options' => true,
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'gf_left_half',
            'description'    => esc_html__('Set the right padding for gf_left_half css ready class', 'et_builder'),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('gf_left_half_padding_right'),
        ];

        return $fields;
    }

    public function gf_left_middle_third_fields()
    {
        $fields                                       = [];
        $fields['gf_left_middle_third_padding_right'] = [
            'label'          => esc_html__('Padding Right', 'et_builder'),
            'type'           => 'range',
            'range_settings' => [
                'min'  => 0,
                'max'  => 100,
                'step' => 1,
            ],
            'mobile_options' => true,
            'tab_slug'       => 'advanced',
            'toggle_slug'    => 'gf_left_middle_third',
            'description'    => esc_html__('Set the right padding for gf_left_third & gf_left_middle css ready class', 'et_builder'),
            'show_if'        => [],
            'allowed_units'  => ['px'],
            'default_unit'   => 'px',
            'default'        => $this->get_default('gf_left_middle_third_padding_right'),
        ];

        return $fields;
    }
}
