<?php
namespace WPT_Divi_Gravity_Modules;

use DiviExtension;

class GravityFormExtension extends DiviExtension {

	protected $container;

	/**
	 * The gettext domain for the extension's translations.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $gettext_domain ;

	/**
	 * The extension's WP Plugin name.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $name = 'et_pb_wpt_gravityform';

	/**
	 * The extension's version
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $version ;

	/**
	 * Constructor.
	 *
	 * @param string $name
	 * @param array  $args
	 */
	public function __construct( $container ) {
		$this->gettext = $container['slug'];
		$this->version = $container['version'];
		$this->plugin_dir     = $container['dir'] . '/';
		$this->plugin_dir_url = $container['url'] . '/';

		$this->container = $container;
		parent::__construct( $this->name, [] );
	}
}